<?php
namespace app\components\modules\payment;

use framework\request\Request;
use framework\helpers\Html;
use app\models\Trans;

class gateway extends Payment
{
    
    private $gateway_url;

    public function request($id, $au, $price, $module, $product)
    {
        if(!extension_loaded('curl') || !function_exists('file_get_contents')) {
            $this->setFlash('danger', 'Curl Extension And file_get_contents Function Required');
            return false;
        }
        
        $this->gateway_url = $module['gateway_url']['value'];
        $price = $price * 10;
        
        $result = $this->req($module['api_key']['value'],$price,urlencode($this->getCallbackUrl($au)));
        $result = json_decode($result,1);
        if($result['status'] == 1) {
            $this->updateAu($id, $result['invoice_key']);
            $go = $this->gateway_url."invoice/pay/".$result['invoice_key'];
            $this->redirect($go);
            return true;
        } else {
            $this->setFlash('danger', 'خطایی رخ داده است - ' . $this->Fault( $result['errorCode'] ) );
            return false;
        }
    }

    public function verify($id, $au, $price, $module, $product)
    {
        if(!extension_loaded('curl') || !function_exists('file_get_contents')) {
            $this->setFlash('danger', 'Curl Extension And file_get_contents Function Required');
            return false;
        }
        $price = $price * 10;
        
        $trans = Trans::model()->getTrans( $au );
        $this->gateway_url = $module['gateway_url']['value'];
        
        $result = $this->check($module['api_key']['value'],$trans->transGatewayAu);
        
        $result = json_decode($result,1);
        if($result['status'] == 1) {
            if($price == $result['amount']) {
                return array( 'au' => $result['bank_code'] );
            } else {
                $this->setFlash('danger', 'خطایی رخ داده است - مبلغ پرداختی با مبلغ فاکتور مغایرت دارد' );
            }
        } else {
            $this->setFlash('danger', 'خطایی رخ داده است - ' . $this->Fault( $result['errorCode'] ));
        }
    
    }

    private function Fault( $Fault ) 
    {
        $array = array(
            100 => 'متد درخواست باید POST باشد',
            101 => 'api_key ست نشده است یا اشتباه است',
            102 => 'مبلغ ست نشده است یا کمتر از 1000 ریال است',
            103 => 'آدرس بازگشت ست نشده است',
            201 => 'وضعیت تراکنش معلق است و پرداختی صورت نگرفته است',
            202 => 'تراکنش کنسل شده است',
            200 => 'شناسه تراکنش اشتباه است',
            301 => 'ارتباط با درگاه بانک برقرار نشد',
        );
        
        if(isset($array[$Fault]))
            return $array[$Fault];
        else
            return 'خطای نامشخص ('.$Fault.')';
    }
    
    
    public function fields()
    {
        return array(
            'gateway_url' => array(
                'label'   => 'آدرس درگاه',
                'value'   => 'https://pay.zardis.net/',
            ),
            'api_key' => array(
                'label' => 'API Key',
                'value' => '',
           ),
        );
    }
    
    private function req($api_key, $amount, $redirect){
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,$this->gateway_url.'invoice/request');
        curl_setopt($ch,CURLOPT_POSTFIELDS,"api_key=$api_key&amount=$amount&return_url=$redirect");
        curl_setopt($ch,CURLOPT_POST,true);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
        curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);
        $res = curl_exec($ch);
        curl_close($ch);
        return $res;
    }
    
    private function check($api_key, $inv_key){
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,$this->gateway_url.'invoice/check/'.$inv_key);
        curl_setopt($ch,CURLOPT_POSTFIELDS,"api_key=$api_key");
        curl_setopt($ch,CURLOPT_POST,true);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
        curl_setopt($ch,CURLOPT_FOLLOWLOCATION,true);
        $res = curl_exec($ch);
        curl_close($ch);
        return $res;
    }
}